/**********************************************
 * @File Name: jquery.mb.YTPlayer.min.js
 * @Author: Matteo Bicocchi
 * @Date: 2020-03-16
 * @Email: matbicoc@gmail.com
 *
 * @Last Modified by: LIQUID THEMES
 * @Last Modified time: 2020-01-13
 * @Copyright: 2020. Matteo Bicocchi
 *
 *  Open Lab s.r.l., Florence - Italy
 *  @blog:  http://pupunzi.open-lab.com
 *  @site:  http://pupunzi.com
 ****************************************************/
"use strict";function onYouTubeIframeAPIReady(){ytp.YTAPIReady||(ytp.YTAPIReady=!0,jQuery(document).trigger("YTAPIReady"))}function isTouchSupported(){var e=nAgt.msMaxTouchPoints,r="ontouchstart"in document.createElement("div");return!(!e&&!r)}function uncamel(e){return e.replace(/([A-Z])/g,(function(e){return"-"+e.toLowerCase()}))}function setUnit(e,r){return"string"!=typeof e||e.match(/^[\-0-9\.]+jQuery/)?""+e+r:e}function setFilter(e,r,t){var a=uncamel(r),o=jQuery.browser.mozilla?"":jQuery.CSS.sfx;e[o+"filter"]=e[o+"filter"]||"",t=setUnit(t>jQuery.CSS.filters[r].max?jQuery.CSS.filters[r].max:t,jQuery.CSS.filters[r].unit),e[o+"filter"]+=a+"("+t+") ",delete e[r]}var ytp=ytp||{};let YTPRndSuffix=(new Date).getTime(),YTPTimerLabels={init:"YTPlayerInit_"+YTPRndSuffix,startPlaying:"YTPlayerStartPlay_"+YTPRndSuffix},getYTPVideoID=function e(r){let t,a;return r.indexOf("youtu.be")>0||r.indexOf("youtube.com/embed")>0?(t=r.substr(r.lastIndexOf("/")+1,r.length),a=t.indexOf("?list=")>0?t.substr(t.lastIndexOf("="),t.length):null,t=a?t.substr(0,t.lastIndexOf("?")):t):r.indexOf("http")>-1?(t=r.match(/[\\?&]v=([^&#]*)/)[1],a=r.indexOf("list=")>0?r.match(/[\\?&]list=([^&#]*)/)[1]:null):(t=r.length>15?null:r,a=t?null:r),{videoID:t,playlistID:a}};(function(jQuery,ytp){jQuery.mbYTPlayer={name:"jquery.mb.YTPlayer",version:"3.3.8",build:"7566",author:"Matteo Bicocchi (pupunzi)",apiKey:"",defaults:{videoURL:null,containment:"body",ratio:"auto",fadeOnStartTime:1e3,startAt:0,stopAt:0,autoPlay:!0,delayAtStart:1e3,coverImage:!1,loop:!0,addRaster:!1,mask:!1,opacity:1,quality:"hd1080",vol:50,mute:!1,showControls:!0,anchor:"center,center",showAnnotations:!1,cc_load_policy:!1,showYTLogo:!0,useOnMobile:!0,playOnlyIfVisible:!1,onScreenPercentage:30,goFullScreenOnPlay:!1,stopMovieOnBlur:!0,realFullscreen:!0,optimizeDisplay:!0,abundance:.3,gaTrack:!0,remember_last_time:!1,addFilters:!1,useNoCookie:!0,onReady:function e(r){},onError:function e(r,t){},onEnd:function e(){}},controls:{play:"P",pause:"p",mute:"M",unmute:"A",onlyYT:"O",showSite:"R",ytLogo:"Y"},controlBar:null,locationProtocol:"https:",defaultFilters:{grayscale:{value:0,unit:"%"},hue_rotate:{value:0,unit:"deg"},invert:{value:0,unit:"%"},opacity:{value:0,unit:"%"},saturate:{value:0,unit:"%"},sepia:{value:0,unit:"%"},brightness:{value:0,unit:"%"},contrast:{value:0,unit:"%"},blur:{value:0,unit:"px"}},buildPlayer:function buildPlayer(options){function isIframe(){let e=!1;try{self.location.href!==top.location.href&&(e=!0)}catch(r){e=!0}return e}if(ytp.YTAPIReady||void 0!==window.YT)setTimeout((function(){jQuery(document).trigger("YTAPIReady"),ytp.YTAPIReady=!0}),100);else{jQuery("#YTAPI").remove();let e=jQuery("<script>").attr({src:"https://www.youtube.com/iframe_api?v="+jQuery.mbYTPlayer.version,id:"YTAPI"});jQuery("head").prepend(e)}return this.each((function(){let YTPlayer=this,$YTPlayer=jQuery(YTPlayer);$YTPlayer.hide(),YTPlayer.loop=0,YTPlayer.state=0,YTPlayer.filters=jQuery.extend(!0,{},jQuery.mbYTPlayer.defaultFilters),YTPlayer.filtersEnabled=!0,YTPlayer.id=YTPlayer.id||"YTP_"+(new Date).getTime(),$YTPlayer.addClass("mb_YTPlayer");let property=$YTPlayer.data("property")&&"string"==typeof $YTPlayer.data("property")?eval("("+$YTPlayer.data("property")+")"):$YTPlayer.data("property");"object"!=typeof property&&(property={}),YTPlayer.opt=jQuery.extend(!0,{},jQuery.mbYTPlayer.defaults,YTPlayer.opt,options,property),YTPRndSuffix=getYTPVideoID(YTPlayer.opt.videoURL).videoID,YTPTimerLabels={init:"YTPlayerInit_"+YTPRndSuffix,startPlaying:"YTPlayerStartPlay_"+YTPRndSuffix},console.time(YTPTimerLabels.init),console.time(YTPTimerLabels.startPlaying),YTPlayer.opt.elementId=YTPlayer.id,0===YTPlayer.opt.vol&&(YTPlayer.opt.vol=1,YTPlayer.opt.mute=!0),YTPlayer.opt.loop&&"boolean"==typeof YTPlayer.opt.loop&&(YTPlayer.opt.loop=9999);let fullScreenAvailable=document.fullscreenEnabled||document.webkitFullscreenEnabled||document.mozFullScreenEnabled||document.msFullscreenEnabled;YTPlayer.opt.realFullscreen=!(isIframe()||!fullScreenAvailable)&&YTPlayer.opt.realFullscreen,YTPlayer.opt.showAnnotations=YTPlayer.opt.showAnnotations?"1":"3",YTPlayer.opt.cc_load_policy=YTPlayer.opt.cc_load_policy?"1":"0",YTPlayer.opt.coverImage=YTPlayer.opt.coverImage||YTPlayer.opt.backgroundImage,YTPlayer.opt.quality="hd1080",jQuery.mbBrowser.msie&&jQuery.mbBrowser.version<9&&(YTPlayer.opt.opacity=1),YTPlayer.opt.containment="self"===YTPlayer.opt.containment?$YTPlayer:jQuery(YTPlayer.opt.containment),YTPlayer.isRetina=window.retina||window.devicePixelRatio>1,YTPlayer.opt.ratio="auto"===YTPlayer.opt.ratio?16/9:YTPlayer.opt.ratio,YTPlayer.opt.ratio=eval(YTPlayer.opt.ratio);let origContainmentBackground=YTPlayer.opt.containment.css("background-image");origContainmentBackground="none"===origContainmentBackground?null:origContainmentBackground,YTPlayer.orig_containment_background=origContainmentBackground,$YTPlayer.attr("id")||$YTPlayer.attr("id","ytp_"+(new Date).getTime()),YTPlayer.playerID="iframe_"+YTPlayer.id,YTPlayer.isAlone=!1,YTPlayer.hasFocus=!0,YTPlayer.videoID=YTPlayer.opt.videoURL?getYTPVideoID(YTPlayer.opt.videoURL).videoID:!!$YTPlayer.attr("href")&&getYTPVideoID($YTPlayer.attr("href")).videoID,YTPlayer.playlistID=YTPlayer.opt.videoURL?getYTPVideoID(YTPlayer.opt.videoURL).playlistID:!!$YTPlayer.attr("href")&&getYTPVideoID($YTPlayer.attr("href")).playlistID;let start_from_last=0;if(jQuery.mbCookie.get("YTPlayer_start_from"+YTPlayer.videoID)&&(start_from_last=parseFloat(jQuery.mbCookie.get("YTPlayer_start_from"+YTPlayer.videoID))),YTPlayer.opt.remember_last_time&&start_from_last&&(YTPlayer.start_from_last=start_from_last,jQuery.mbCookie.remove("YTPlayer_start_from"+YTPlayer.videoID)),YTPlayer.isPlayer=$YTPlayer.is(YTPlayer.opt.containment),YTPlayer.isBackground=YTPlayer.opt.containment.is("body"),YTPlayer.isBackground&&ytp.backgroundIsInited)return;if(YTPlayer.isPlayer&&$YTPlayer.show(),YTPlayer.overlay=jQuery("<div/>").css({position:"absolute",top:0,left:0,width:"100%",height:"100%"}).addClass("YTPOverlay"),$YTPlayer.changeCoverImage(),YTPlayer.wrapper=jQuery("<div/>").attr("id","wrapper_"+YTPlayer.id).css({position:"absolute",zIndex:0,minWidth:"100%",minHeight:"100%",left:0,top:0,overflow:"hidden",opacity:0}).addClass("mbYTP_wrapper"),YTPlayer.isPlayer){let e=jQuery.browser.mobile?"inlinePlayButtonMobile":"inlinePlayButton";YTPlayer.inlinePlayButton=jQuery("<div/>").addClass("inlinePlayButton").html(jQuery.mbYTPlayer.controls.play),$YTPlayer.append(YTPlayer.inlinePlayButton),YTPlayer.inlinePlayButton.on("click",(function(e){$YTPlayer.YTPPlay(),YTPlayer.inlinePlayButton.hide(),YTPlayer.opt.goFullScreenOnPlay&&$YTPlayer.YTPFullscreen(),e.stopPropagation()})),YTPlayer.opt.autoPlay&&YTPlayer.inlinePlayButton.hide(),YTPlayer.overlay.on("click",(function(){$YTPlayer.YTPTogglePlay(),YTPlayer.opt.goFullScreenOnPlay&&$YTPlayer.YTPFullscreen()})).css({cursor:"pointer"})}let playerBox=jQuery("<div/>").attr("id",YTPlayer.playerID).addClass("playerBox");if(playerBox.css({position:"absolute",zIndex:0,width:"100%",height:"100%",top:0,left:0,overflow:"hidden",opacity:1}),YTPlayer.wrapper.append(playerBox),playerBox.after(YTPlayer.overlay),YTPlayer.isPlayer&&(YTPlayer.inlineWrapper=jQuery("<div/>").addClass("inline-YTPlayer"),YTPlayer.inlineWrapper.css({position:"relative",maxWidth:YTPlayer.opt.containment.css("width")}),YTPlayer.opt.containment.css({position:"relative",paddingBottom:"56.25%",overflow:"hidden",height:0}),YTPlayer.opt.containment.wrap(YTPlayer.inlineWrapper)),YTPlayer.opt.containment.children().not("script, style").each((function(){"static"===jQuery(this).css("position")&&jQuery(this).css("position","relative")})),YTPlayer.isBackground?(jQuery("body").css({boxSizing:"border-box"}),YTPlayer.wrapper.css({position:"fixed",top:0,left:0,zIndex:0})):"static"===YTPlayer.opt.containment.css("position")&&(YTPlayer.opt.containment.css({position:"relative"}),$YTPlayer.show()),YTPlayer.opt.containment.prepend(YTPlayer.wrapper),YTPlayer.isBackground||YTPlayer.overlay.on("mouseenter",(function(){YTPlayer.controlBar&&YTPlayer.controlBar.length&&YTPlayer.controlBar.addClass("visible")})).on("mouseleave",(function(){YTPlayer.controlBar&&YTPlayer.controlBar.length&&YTPlayer.controlBar.removeClass("visible")})),jQuery.mbBrowser.mobile&&!YTPlayer.opt.useOnMobile)return YTPlayer.opt.coverImage&&(YTPlayer.wrapper.css({backgroundImage:"url("+YTPlayer.opt.coverImage+")",backgroundPosition:"center center",backgroundSize:"cover",backgroundRepeat:"no-repeat",opacity:1}),YTPlayer.wrapper.css({opacity:1})),$YTPlayer;jQuery.mbBrowser.mobile&&YTPlayer.opt.autoPlay&&YTPlayer.opt.useOnMobile&&jQuery("body").one("touchstart",(function(){YTPlayer.player.playVideo()})),jQuery(document).one("YTAPIReady",(function(){$YTPlayer.trigger("YTAPIReady_"+YTPlayer.id),ytp.YTAPIReady=!0})),YTPlayer.isOnScreen=jQuery.mbYTPlayer.isOnScreen(YTPlayer,YTPlayer.opt.onScreenPercentage),$YTPlayer.one("YTAPIReady_"+YTPlayer.id,(function(){let e=this,r=jQuery(e);e.isBackground&&ytp.backgroundIsInited||e.isInit||(e.isBackground&&(ytp.backgroundIsInited=!0),e.opt.autoPlay=void 0===e.opt.autoPlay?!!e.isBackground:e.opt.autoPlay,e.opt.vol=e.opt.vol?e.opt.vol:100,jQuery.mbYTPlayer.getDataFromAPI(e),jQuery(e).on("YTPChanged",(function(t){if(e.isInit)return;e.isInit=!0;let a={modestbranding:1,autoplay:0,controls:0,showinfo:0,rel:0,enablejsapi:1,version:3,playerapiid:e.playerID,origin:"*",allowfullscreen:!0,wmode:"transparent",iv_load_policy:e.opt.showAnnotations,cc_load_policy:e.opt.cc_load_policy,playsinline:1,html5:document.createElement("video").canPlayType?1:0};YT.ready((function(){new YT.Player(e.playerID,{host:e.opt.useNoCookie?"https://www.youtube-nocookie.com":"https://www.youtube.com",playerVars:a,events:{onReady:function t(a){e.player=a.target,e.player.loadVideoById({videoId:e.videoID.toString(),suggestedQuality:e.opt.quality}),r.trigger("YTPlayerIsReady_"+e.id)},onStateChange:function r(t){if("function"!=typeof t.target.getPlayerState)return;let a=t.target.getPlayerState(),o;if(e.preventTrigger||e.isStarting)return void(e.preventTrigger=!1);switch(e.state=a,t.data===YT.PlayerState.PLAYING&&t.target.setPlaybackQuality(e.opt.quality),a){case-1:o="YTPUnstarted";break;case 0:o="YTPRealEnd";break;case 1:o="YTPPlay",e.controlBar.length&&e.controlBar.find(".mb_YTPPlayPause").html(jQuery.mbYTPlayer.controls.pause),e.isPlayer&&e.inlinePlayButton.hide(),jQuery(document).off("mousedown.YTPstart");break;case 2:o="YTPPause",e.controlBar.length&&e.controlBar.find(".mb_YTPPlayPause").html(jQuery.mbYTPlayer.controls.play),e.isPlayer&&e.inlinePlayButton.show();break;case 3:e.player.setPlaybackQuality(e.opt.quality),o="YTPBuffering",e.controlBar.length&&e.controlBar.find(".mb_YTPPlayPause").html(jQuery.mbYTPlayer.controls.play);break;case 5:o="YTPCued";break;default:break}let l=jQuery.Event(o);l.time=e.currentTime,jQuery(e).trigger(l)},onPlaybackQualityChange:function r(t){let a=t.target.getPlaybackQuality(),o=jQuery.Event("YTPQualityChange");o.quality=a,jQuery(e).trigger(o)},onError:function t(a){switch("function"==typeof e.opt.onError&&e.opt.onError(r,a),console.debug("error:",a),a.data){case 2:console.error("video ID:: "+e.videoID+": The request contains an invalid parameter value. For example, this error occurs if you specify a video ID that does not have 11 characters, or if the video ID contains invalid characters, such as exclamation points or asterisks.");break;case 5:console.error("video ID:: "+e.videoID+": The requested content cannot be played in an HTML5 player or another error related to the HTML5 player has occurred.");break;case 100:console.error("video ID:: "+e.videoID+": The video requested was not found. This error occurs when a video has been removed (for any reason) or has been marked as private.");break;case 101:case 150:console.error("video ID:: "+e.videoID+": The video doesn't exist or The owner does not allow it to be played in embedded players.");break}e.isList&&jQuery(e).YTPPlayNext()}}})})),r.on("YTPlayerIsReady_"+e.id,(function(){if(e.isReady)return this;e.playerEl=e.player.getIframe(),jQuery(e.playerEl).unselectable(),r.optimizeDisplay(),jQuery(window).off("resize.YTP_"+e.id).on("resize.YTP_"+e.id,(function(){r.optimizeDisplay()})),jQuery(window).off("orientationchange.YTP_"+e.id).on("orientationchange.YTP_"+e.id,(function(){r.optimizeDisplay()})),e.opt.remember_last_time&&jQuery(window).on("unload.YTP_"+e.id,(function(){let r=e.player.getCurrentTime();jQuery.mbCookie.set("YTPlayer_start_from"+e.videoID,r,0)})),r.YTPCheckForState()}))})))})),$YTPlayer.off("YTPTime.mask"),jQuery.mbYTPlayer.applyMask(YTPlayer),console.timeEnd(YTPTimerLabels.init),setTimeout((function(){ytp.YTAPIReady||"object"!=typeof window.YT||(jQuery(document).trigger("YTAPIReady"),ytp.YTAPIReady=!0,console.error("YTPlayer: More then a call to the YT API has been detected"))}),YTPlayer.opt.delayAtStart)}))},isOnScreen:function e(r,t){t=t||10;let a=r.wrapper,o=jQuery(window).scrollTop(),l=o+jQuery(window).height(),n=a.height()*t/100,i=a.offset().top+n,s;return a.offset().top+(a.height()-n)<=l&&i>=o},getDataFromAPI:function e(r){r.videoData=jQuery.mbStorage.get("YTPlayer_data_"+r.videoID),r.videoData?(setTimeout((function(){r.dataReceived=!0;let e=jQuery.Event("YTPChanged");e.time=r.currentTime,e.videoId=r.videoID,e.opt=r.opt,jQuery(r).trigger(e);let t=jQuery.Event("YTPData");t.prop={};for(let e in r.videoData)r.videoData.hasOwnProperty(e)&&(t.prop[e]=r.videoData[e]);jQuery(r).trigger(t)}),r.opt.fadeOnStartTime),r.hasData=!0):jQuery.mbYTPlayer.apiKey?jQuery.getJSON("https://www.googleapis.com/youtube/v3/videos?id="+r.videoID+"&key="+jQuery.mbYTPlayer.apiKey+"&part=snippet",(function(e){function t(e){r.videoData={},r.videoData.id=r.videoID,r.videoData.channelTitle=e.channelTitle,r.videoData.title=e.title,r.videoData.description=e.description.length<400?e.description:e.description.substring(0,400)+" ...",r.videoData.thumb_max=e.thumbnails.maxres?e.thumbnails.maxres.url:null,r.videoData.thumb_high=e.thumbnails.high?e.thumbnails.high.url:null,r.videoData.thumb_medium=e.thumbnails.medium?e.thumbnails.medium.url:null,jQuery.mbStorage.set("YTPlayer_data_"+r.videoID,r.videoData)}r.dataReceived=!0;let a=jQuery.Event("YTPChanged");a.time=r.currentTime,a.videoId=r.videoID,jQuery(r).trigger(a),e.items[0]?(t(e.items[0].snippet),r.hasData=!0):(r.videoData={},r.hasData=!1);let o=jQuery.Event("YTPData");o.prop={};for(let e in r.videoData)o.prop[e]=r.videoData[e];jQuery(r).trigger(o)})).fail((function(e){console.error("YT data error:: ",e),r.hasData=!1;let t=jQuery.Event("YTPChanged");t.time=r.currentTime,t.videoId=r.videoID,jQuery(r).trigger(t)})):(setTimeout((function(){let e=jQuery.Event("YTPChanged");e.time=r.currentTime,e.videoId=r.videoID,jQuery(r).trigger(e)}),10),r.videoData=null),r.opt.ratio="auto"==r.opt.ratio?16/9:r.opt.ratio,r.isPlayer&&!r.opt.autoPlay&&(r.loading=jQuery("<div/>").addClass("loading").html("Loading").hide(),jQuery(r).append(r.loading),r.loading.fadeIn())},removeStoredData:function e(){jQuery.mbStorage.remove()},getVideoData:function e(){let r;return this.get(0).videoData},getVideoID:function e(){let r;return this.get(0).videoID||!1},getPlaylistID:function e(){let r;return this.get(0).playlistID||!1},setVideoQuality:function e(r){let t=this.get(0),a=t.player.getCurrentTime();return jQuery(t).YTPPause(),t.opt.quality=r,t.player.setPlaybackQuality(r),t.player.seekTo(a),jQuery(t).YTPPlay(),this},getVideoQuality:function e(){let r,t;return this.get(0).player.getPlaybackQuality()},playlist:function e(r,t,a){let o,l=this.get(0);return l.isList=!0,t&&(r=jQuery.shuffle(r)),l.videoID||(l.videos=r,l.videoCounter=1,l.videoLength=r.length,jQuery(l).data("property",r[0]),jQuery(l).YTPlayer()),"function"==typeof a&&jQuery(l).on("YTPChanged",(function(){a(l)})),jQuery(l).on("YTPEnd",(function(){jQuery(l).YTPPlayNext()})),this},playNext:function e(){let r=this.get(0);return r.videoCounter++,r.videoCounter>r.videoLength&&(r.videoCounter=1),jQuery(r).YTPPlayIndex(r.videoCounter),this},playPrev:function e(){let r=this.get(0);return r.videoCounter--,r.videoCounter<=0&&(r.videoCounter=r.videoLength),jQuery(r).YTPPlayIndex(r.videoCounter),this},playIndex:function e(r){let t=this.get(0);t.checkForStartAt&&(clearInterval(t.checkForStartAt),clearInterval(t.getState)),t.videoCounter=r,t.videoCounter>=t.videoLength&&(t.videoCounter=t.videoLength);let a=t.videos[t.videoCounter-1];return jQuery(t).YTPChangeVideo(a),this},changeVideo:function e(r){let t=this,a=t.get(0);a.opt.startAt=0,a.opt.stopAt=0,a.opt.mask=!1,a.opt.mute=!0,a.opt.autoPlay=!0,a.opt.addFilters=!1,a.opt.coverImage=!1,a.hasData=!1,a.hasChanged=!0,a.player.loopTime=void 0,r&&jQuery.extend(a.opt,r),a.videoID=getYTPVideoID(a.opt.videoURL).videoID,a.opt.loop&&"boolean"==typeof a.opt.loop&&(a.opt.loop=9999),a.wrapper.css({background:"none"}),jQuery(a.playerEl).CSSAnimate({opacity:0},a.opt.fadeOnStartTime,(function(){jQuery.mbYTPlayer.getDataFromAPI(a),t.YTPGetPlayer().loadVideoById({videoId:a.videoID,suggestedQuality:a.opt.quality}),t.YTPPause(),t.optimizeDisplay(),a.checkForStartAt&&(clearInterval(a.checkForStartAt),clearInterval(a.getState)),t.YTPCheckForState()}));let o=jQuery.Event("YTPChangeVideo");return o.time=a.currentTime,jQuery(a).trigger(o),jQuery.mbYTPlayer.applyMask(a),this},getPlayer:function e(){let r=this.get(0);return r.isReady?r.player:null},playerDestroy:function e(){let r=this.get(0);return r.isReady?(ytp.YTAPIReady=!0,ytp.backgroundIsInited=!1,r.isInit=!1,r.videoID=null,r.isReady=!1,r.wrapper.remove(),jQuery("#controlBar_"+r.id).remove(),clearInterval(r.checkForStartAt),clearInterval(r.getState),this):this},fullscreen:function fullscreen(real){function RunPrefixMethod(e,r){let t=["webkit","moz","ms","o",""],a=0,o,l;for(;a<t.length&&!e[o];){if(o=r,""===t[a]&&(o=o.substr(0,1).toLowerCase()+o.substr(1)),o=t[a]+o,l=typeof e[o],"undefined"!=l)return t=[t[a]],"function"==l?e[o]():e[o];a++}}function launchFullscreen(e){RunPrefixMethod(e,"RequestFullScreen")}function cancelFullscreen(){(RunPrefixMethod(document,"FullScreen")||RunPrefixMethod(document,"IsFullScreen"))&&RunPrefixMethod(document,"CancelFullScreen")}let YTPlayer=this.get(0);void 0===real&&(real=eval(YTPlayer.opt.realFullscreen));let controls=jQuery("#controlBar_"+YTPlayer.id),fullScreenBtn=controls.find(".mb_OnlyYT"),videoWrapper=YTPlayer.isPlayer?YTPlayer.opt.containment:YTPlayer.wrapper;if(real){let e=jQuery.mbBrowser.mozilla?"mozfullscreenchange":jQuery.mbBrowser.webkit?"webkitfullscreenchange":"fullscreenchange";jQuery(document).off(e).on(e,(function(){let e;RunPrefixMethod(document,"IsFullScreen")||RunPrefixMethod(document,"FullScreen")?jQuery(YTPlayer).trigger("YTPFullScreenStart"):(YTPlayer.isAlone=!1,fullScreenBtn.html(jQuery.mbYTPlayer.controls.onlyYT),jQuery(YTPlayer).YTPSetVideoQuality(YTPlayer.opt.quality),videoWrapper.removeClass("YTPFullscreen"),videoWrapper.CSSAnimate({opacity:YTPlayer.opt.opacity},YTPlayer.opt.fadeOnStartTime),videoWrapper.css({zIndex:0}),YTPlayer.isBackground?jQuery("body").after(controls):YTPlayer.wrapper.before(controls),jQuery(window).resize(),jQuery(YTPlayer).trigger("YTPFullScreenEnd"))}))}if(YTPlayer.isAlone)jQuery(document).off("mousemove.YTPlayer"),clearTimeout(YTPlayer.hideCursor),YTPlayer.overlay.css({cursor:"auto"}),real?cancelFullscreen():(videoWrapper.CSSAnimate({opacity:YTPlayer.opt.opacity},YTPlayer.opt.fadeOnStartTime),videoWrapper.css({zIndex:0})),fullScreenBtn.html(jQuery.mbYTPlayer.controls.onlyYT),YTPlayer.isAlone=!1;else{function hideMouse(){YTPlayer.overlay.css({cursor:"none"})}jQuery(document).on("mousemove.YTPlayer",(function(e){YTPlayer.overlay.css({cursor:"auto"}),clearTimeout(YTPlayer.hideCursor),jQuery(e.target).parents().is(".mb_YTPBar")||(YTPlayer.hideCursor=setTimeout(hideMouse,3e3))})),hideMouse(),real?(videoWrapper.css({opacity:0}),videoWrapper.addClass("YTPFullscreen"),launchFullscreen(videoWrapper.get(0)),setTimeout((function(){videoWrapper.CSSAnimate({opacity:1},2*YTPlayer.opt.fadeOnStartTime),videoWrapper.append(controls),jQuery(YTPlayer).optimizeDisplay(),YTPlayer.player.seekTo(YTPlayer.player.getCurrentTime()+.1,!0)}),YTPlayer.opt.fadeOnStartTime)):videoWrapper.css({zIndex:1e4}).CSSAnimate({opacity:1},2*YTPlayer.opt.fadeOnStartTime),fullScreenBtn.html(jQuery.mbYTPlayer.controls.showSite),YTPlayer.isAlone=!0}return this},toggleLoops:function e(){let r=this.get(0),t=r.opt;return 1==t.loop?t.loop=0:(t.startAt?r.player.seekTo(t.startAt):r.player.playVideo(),t.loop=1),this},play:function e(){let r=this.get(0),t=jQuery(r),a,o;return r.isReady?(setTimeout((function(){t.YTPSetAbundance(r.opt.abundance)}),300),r.player.playVideo(),jQuery(r.playerEl).css({opacity:1}),r.wrapper.css({backgroundImage:"none"}),r.wrapper.CSSAnimate({opacity:r.isAlone?1:r.opt.opacity},r.opt.fadeOnStartTime),jQuery("#controlBar_"+r.id).find(".mb_YTPPlayPause").html(jQuery.mbYTPlayer.controls.pause),r.state=1,this):this},togglePlay:function e(r){let t=this.get(0);return t.isReady?(1===t.state?this.YTPPause():this.YTPPlay(),"function"==typeof r&&r(t.state),this):this},stop:function e(){let r=this.get(0),t,a;return r.isReady?(jQuery("#controlBar_"+r.id).find(".mb_YTPPlayPause").html(jQuery.mbYTPlayer.controls.play),r.player.stopVideo(),this):this},pause:function e(){let r=this.get(0);return r.isReady?(r.opt.abundance<.2&&this.YTPSetAbundance(.2),r.player.pauseVideo(),r.state=2,this):this},seekTo:function e(r){let t=this.get(0);return t.isReady?(t.player.seekTo(r,!0),this):this},getPlaybackRate:function e(){let r=this.get(0);return r.isReady?r.player.getPlaybackRate():this},setPlaybackRate:function e(r){let t=this.get(0);return t.isReady?(t.player.setPlaybackRate(r),this):this},setVolume:function e(r){let t=this.get(0);return t.isReady?(t.opt.vol=r,this.YTPUnmute(),t.player.setVolume(t.opt.vol),t.volumeBar&&t.volumeBar.length&&t.volumeBar.updateSliderVal(r),this):this},getVolume:function e(){let r=this.get(0);return r.isReady?r.player.getVolume():this},toggleVolume:function e(){let r=this.get(0);return r.isReady?(r.isMute?(jQuery.mbBrowser.mobile||this.YTPSetVolume(r.opt.vol),this.YTPUnmute()):this.YTPMute(),this):this},mute:function e(){let r=this.get(0),t,a;if(!r.isReady)return this;if(r.isMute)return this;r.player.mute(),r.isMute=!0,r.player.setVolume(0),r.volumeBar&&r.volumeBar.length&&r.volumeBar.width()>10&&r.volumeBar.updateSliderVal(0),jQuery("#controlBar_"+r.id).find(".mb_YTPMuteUnmute").html(jQuery.mbYTPlayer.controls.unmute),jQuery(r).addClass("isMuted"),r.volumeBar&&r.volumeBar.length&&r.volumeBar.addClass("muted");let o=jQuery.Event("YTPMuted");return o.time=r.currentTime,r.preventTrigger||jQuery(r).trigger(o),this},unmute:function e(){let r=this.get(0),t,a;if(!r.isReady)return this;if(!r.isMute)return this;r.player.unMute(),r.isMute=!1,jQuery(r).YTPSetVolume(r.opt.vol),r.volumeBar&&r.volumeBar.length&&r.volumeBar.updateSliderVal(r.opt.vol>10?r.opt.vol:10),jQuery("#controlBar_"+r.id).find(".mb_YTPMuteUnmute").html(jQuery.mbYTPlayer.controls.mute),jQuery(r).removeClass("isMuted"),r.volumeBar&&r.volumeBar.length&&r.volumeBar.removeClass("muted");let o=jQuery.Event("YTPUnmuted");return o.time=r.currentTime,r.preventTrigger||jQuery(r).trigger(o),this},applyFilter:function e(r,t){let a=this,o=a.get(0);if(!o.isReady)return this;o.filters[r].value=t,o.filtersEnabled&&a.YTPEnableFilters()},applyFilters:function e(r){let t=this,a=t.get(0);if(!a.isReady)return jQuery(a).on("YTPReady",(function(){t.YTPApplyFilters(r)})),this;for(let e in r)t.YTPApplyFilter(e,r[e]);t.trigger("YTPFiltersApplied")},toggleFilter:function e(r,t){let a,o=this.get(0);return o.isReady?(o.filters[r].value?o.filters[r].value=0:o.filters[r].value=t,o.filtersEnabled&&jQuery(o).YTPEnableFilters(),this):this},toggleFilters:function e(r){let t,a=this.get(0);return a.isReady?(a.filtersEnabled?(jQuery(a).trigger("YTPDisableFilters"),jQuery(a).YTPDisableFilters()):(jQuery(a).YTPEnableFilters(),jQuery(a).trigger("YTPEnableFilters")),"function"==typeof r&&r(a.filtersEnabled),this):this},disableFilters:function e(){let r,t=this.get(0);if(!t.isReady)return this;let a=jQuery(t.playerEl);return a.css("-webkit-filter",""),a.css("filter",""),t.filtersEnabled=!1,this},enableFilters:function e(){let r,t=this.get(0);if(!t.isReady)return this;let a=jQuery(t.playerEl),o="";for(let e in t.filters)t.filters[e].value&&(o+=e.replace("_","-")+"("+t.filters[e].value+t.filters[e].unit+") ");return a.css("-webkit-filter",o),a.css("filter",o),t.filtersEnabled=!0,this},removeFilter:function e(r,t){let a=this,o=a.get(0);if(!o.isReady)return this;if("function"==typeof r&&(t=r,r=null),r)a.YTPApplyFilter(r,0),"function"==typeof t&&t(r);else{for(let e in o.filters)o.filters.hasOwnProperty(e)&&(a.YTPApplyFilter(e,0),"function"==typeof t&&t(e));o.filters=jQuery.extend(!0,{},jQuery.mbYTPlayer.defaultFilters)}let l=jQuery.Event("YTPFiltersApplied");return a.trigger(l),this},getFilters:function e(){let r=this.get(0);return r.isReady?r.filters:this},addMask:function e(r){let t=this.get(0);r||(r=t.actualMask);let a=jQuery("<img/>").attr("src",r).on("load",(function(){t.overlay.CSSAnimate({opacity:0},t.opt.fadeOnStartTime,(function(){t.hasMask=!0,a.remove(),t.overlay.css({backgroundImage:"url("+r+")",backgroundRepeat:"no-repeat",backgroundPosition:"center center",backgroundSize:"cover"}),t.overlay.CSSAnimate({opacity:1},t.opt.fadeOnStartTime)}))}));return this},removeMask:function e(){let r=this.get(0);return r.overlay.CSSAnimate({opacity:0},r.opt.fadeOnStartTime,(function(){r.hasMask=!1,r.overlay.css({backgroundImage:"",backgroundRepeat:"",backgroundPosition:"",backgroundSize:""}),r.overlay.CSSAnimate({opacity:1},r.opt.fadeOnStartTime)})),this},applyMask:function e(r){let t=jQuery(r);if(t.off("YTPTime.mask"),r.opt.mask)if("string"==typeof r.opt.mask)t.YTPAddMask(r.opt.mask),r.actualMask=r.opt.mask;else if("object"==typeof r.opt.mask){for(let e in r.opt.mask)if(r.opt.mask[e]){let t=jQuery("<img/>").attr("src",r.opt.mask[e])}r.opt.mask[0]&&t.YTPAddMask(r.opt.mask[0]),t.on("YTPTime.mask",(function(e){for(let a in r.opt.mask)e.time===a&&(r.opt.mask[a]?(t.YTPAddMask(r.opt.mask[a]),r.actualMask=r.opt.mask[a]):t.YTPRemoveMask())}))}},toggleMask:function e(){let r=this.get(0),t=jQuery(r);return r.hasMask?t.YTPRemoveMask():t.YTPAddMask(),this},manageProgress:function e(){let r=this.get(0),t=jQuery("#controlBar_"+r.id),a=t.find(".mb_YTPProgress"),o=t.find(".mb_YTPLoaded"),l=t.find(".mb_YTPseekbar"),n=a.outerWidth(),i=Math.floor(r.player.getCurrentTime()),s=Math.floor(r.player.getDuration()),u=i*n/s,y=0,d=100*r.player.getVideoLoadedFraction();return o.css({left:0,width:d+"%"}),l.css({left:0,width:u}),{totalTime:s,currentTime:i}},buildControls:function buildControls(YTPlayer){if(jQuery("#controlBar_"+YTPlayer.id).remove(),!YTPlayer.opt.showControls)return void(YTPlayer.controlBar=!1);if(YTPlayer.opt.showYTLogo=YTPlayer.opt.showYTLogo||YTPlayer.opt.printUrl,jQuery("#controlBar_"+YTPlayer.id).length)return;YTPlayer.controlBar=jQuery("<div/>").attr("id","controlBar_"+YTPlayer.id).addClass("mb_YTPBar").css({whiteSpace:"noWrap",position:YTPlayer.isBackground?"fixed":"absolute",zIndex:YTPlayer.isBackground?1e4:1e3}).hide().on("click",(function(e){e.stopPropagation()}));let buttonBar=jQuery("<div/>").addClass("buttonBar"),playpause=jQuery("<span>"+jQuery.mbYTPlayer.controls.play+"</span>").addClass("mb_YTPPlayPause ytpicon").on("click",(function(e){e.stopPropagation(),jQuery(YTPlayer).YTPTogglePlay()})),MuteUnmute=jQuery("<span>"+jQuery.mbYTPlayer.controls.mute+"</span>").addClass("mb_YTPMuteUnmute ytpicon").on("click",(function(e){e.stopPropagation(),jQuery(YTPlayer).YTPToggleVolume()})),volumeBar=jQuery("<div/>").addClass("mb_YTPVolumeBar").css({display:"inline-block"});YTPlayer.volumeBar=volumeBar;let idx=jQuery("<span/>").addClass("mb_YTPTime"),vURL=YTPlayer.opt.videoURL?YTPlayer.opt.videoURL:"";vURL.indexOf("http")<0&&(vURL="https://www.youtube.com/watch?v="+YTPlayer.opt.videoURL);let movieUrl=jQuery("<span/>").html(jQuery.mbYTPlayer.controls.ytLogo).addClass("mb_YTPUrl ytpicon").attr("title","view on YouTube").on("click",(function(){window.open(vURL,"viewOnYT")})),onlyVideo=jQuery("<span/>").html(jQuery.mbYTPlayer.controls.onlyYT).addClass("mb_OnlyYT ytpicon").on("click",(function(e){e.stopPropagation(),jQuery(YTPlayer).YTPFullscreen(YTPlayer.opt.realFullscreen)})),progressBar=jQuery("<div/>").addClass("mb_YTPProgress").css("position","absolute").on("click",(function(e){e.stopPropagation(),timeBar.css({width:e.clientX-timeBar.offset().left}),YTPlayer.timeW=e.clientX-timeBar.offset().left,YTPlayer.controlBar.find(".mb_YTPLoaded").css({width:0});let r=Math.floor(YTPlayer.player.getDuration());YTPlayer.goto=timeBar.outerWidth()*r/progressBar.outerWidth(),YTPlayer.player.seekTo(parseFloat(YTPlayer.goto),!0),YTPlayer.controlBar.find(".mb_YTPLoaded").css({width:0})})),loadedBar=jQuery("<div/>").addClass("mb_YTPLoaded").css("position","absolute"),timeBar=jQuery("<div/>").addClass("mb_YTPseekbar").css("position","absolute");progressBar.append(loadedBar).append(timeBar),buttonBar.append(playpause).append(MuteUnmute).append(volumeBar).append(idx),YTPlayer.opt.showYTLogo&&buttonBar.append(movieUrl),(YTPlayer.isBackground||eval(YTPlayer.opt.realFullscreen)&&!YTPlayer.isBackground)&&buttonBar.append(onlyVideo),YTPlayer.controlBar.append(buttonBar).append(progressBar),YTPlayer.isBackground?jQuery("body").after(YTPlayer.controlBar):(YTPlayer.controlBar.addClass("inlinePlayer"),YTPlayer.wrapper.before(YTPlayer.controlBar)),volumeBar.simpleSlider({initialval:YTPlayer.opt.vol,scale:100,orientation:"h",callback:function e(r){0==r.value?jQuery(YTPlayer).YTPMute():jQuery(YTPlayer).YTPUnmute(),YTPlayer.player.setVolume(r.value),YTPlayer.isMute||(YTPlayer.opt.vol=r.value)}})},changeCoverImage:function e(r){let t=this.get(0);if(t.opt.coverImage||t.orig_containment_background){let e=r||(t.opt.coverImage?"url("+t.opt.coverImage+") center center":t.orig_containment_background);e&&t.opt.containment.css({background:e,backgroundSize:"cover",backgroundRepeat:"no-repeat",backgroundAttachment:"fixed"})}return this},checkForState:function checkForState(){let YTPlayer=this.get(0),$YTPlayer=jQuery(YTPlayer);clearInterval(YTPlayer.getState);let interval=100;if(!jQuery.contains(document,YTPlayer))return $YTPlayer.YTPPlayerDestroy(),clearInterval(YTPlayer.getState),void clearInterval(YTPlayer.checkForStartAt);jQuery.mbYTPlayer.checkForStart(YTPlayer),YTPlayer.getState=setInterval((function(){let $YTPlayer=jQuery(YTPlayer);if(!YTPlayer.isReady)return;let prog=jQuery(YTPlayer).YTPManageProgress(),stopAt=YTPlayer.opt.stopAt>YTPlayer.opt.startAt?YTPlayer.opt.stopAt:0;if(stopAt=stopAt<YTPlayer.player.getDuration()?stopAt:0,YTPlayer.currentTime!=prog.currentTime){let e=jQuery.Event("YTPTime");e.time=YTPlayer.currentTime,jQuery(YTPlayer).trigger(e)}if(YTPlayer.currentTime=prog.currentTime,YTPlayer.totalTime=YTPlayer.player.getDuration(),0==YTPlayer.player.getVolume()?$YTPlayer.addClass("isMuted"):$YTPlayer.removeClass("isMuted"),YTPlayer.opt.showControls&&(prog.totalTime?YTPlayer.controlBar.find(".mb_YTPTime").html(jQuery.mbYTPlayer.formatTime(prog.currentTime)+" / "+jQuery.mbYTPlayer.formatTime(prog.totalTime)):YTPlayer.controlBar.find(".mb_YTPTime").html("-- : -- / -- : --")),eval(YTPlayer.opt.stopMovieOnBlur)&&(document.hasFocus()?document.hasFocus()&&!YTPlayer.hasFocus&&-1!=YTPlayer.state&&0!=YTPlayer.state&&(YTPlayer.hasFocus=!0,YTPlayer.preventTrigger=!0,$YTPlayer.YTPPlay()):1==YTPlayer.state&&(YTPlayer.hasFocus=!1,YTPlayer.preventTrigger=!0,$YTPlayer.YTPPause())),YTPlayer.opt.playOnlyIfVisible){let e=jQuery.mbYTPlayer.isOnScreen(YTPlayer,YTPlayer.opt.onScreenPercentage);e||1!=YTPlayer.state?e&&!YTPlayer.isOnScreen&&(YTPlayer.isOnScreen=!0,YTPlayer.player.playVideo()):(YTPlayer.isOnScreen=!1,$YTPlayer.YTPPause())}if(YTPlayer.controlBar.length&&YTPlayer.controlBar.outerWidth()<=400&&!YTPlayer.isCompact?(YTPlayer.controlBar.addClass("compact"),YTPlayer.isCompact=!0,
!YTPlayer.isMute&&YTPlayer.volumeBar&&YTPlayer.volumeBar.updateSliderVal(YTPlayer.opt.vol)):YTPlayer.controlBar.length&&YTPlayer.controlBar.outerWidth()>400&&YTPlayer.isCompact&&(YTPlayer.controlBar.removeClass("compact"),YTPlayer.isCompact=!1,!YTPlayer.isMute&&YTPlayer.volumeBar&&YTPlayer.volumeBar.updateSliderVal(YTPlayer.opt.vol)),YTPlayer.player.getPlayerState()>0&&(parseFloat(YTPlayer.player.getDuration()-YTPlayer.opt.fadeOnStartTime/1e3)<YTPlayer.player.getCurrentTime()||stopAt>0&&parseFloat(YTPlayer.player.getCurrentTime())>=stopAt)){if(YTPlayer.isEnded)return;if(YTPlayer.isEnded=!0,setTimeout((function(){YTPlayer.isEnded=!1}),1e3),YTPlayer.isList){if(!YTPlayer.opt.loop||YTPlayer.opt.loop>0&&YTPlayer.player.loopTime===YTPlayer.opt.loop-1){YTPlayer.player.loopTime=void 0,clearInterval(YTPlayer.getState);let e=jQuery.Event("YTPEnd");return e.time=YTPlayer.currentTime,void jQuery(YTPlayer).trigger(e)}}else if(!YTPlayer.opt.loop||YTPlayer.opt.loop>0&&YTPlayer.player.loopTime===YTPlayer.opt.loop-1)return YTPlayer.player.loopTime=void 0,YTPlayer.state=2,$YTPlayer.changeCoverImage(YTPlayer),jQuery(YTPlayer).YTPPause(),void YTPlayer.wrapper.CSSAnimate({opacity:0},YTPlayer.opt.fadeOnStartTime,(function(){YTPlayer.controlBar.length&&YTPlayer.controlBar.find(".mb_YTPPlayPause").html(jQuery.mbYTPlayer.controls.play),$YTPlayer.changeCoverImage();let e=jQuery.Event("YTPEnd");e.time=YTPlayer.currentTime,jQuery(YTPlayer).trigger(e),YTPlayer.player.seekTo(YTPlayer.opt.startAt,!0)}));YTPlayer.player.loopTime=YTPlayer.player.loopTime?++YTPlayer.player.loopTime:1,YTPlayer.opt.startAt=YTPlayer.opt.startAt||1,YTPlayer.preventTrigger=!0,YTPlayer.state=2,YTPlayer.player.seekTo(YTPlayer.opt.startAt,!0)}}),interval)},checkForStart:function checkForStart(YTPlayer){let $YTPlayer=jQuery(YTPlayer);if(!jQuery.contains(document,YTPlayer))return void $YTPlayer.YTPPlayerDestroy();if(jQuery.mbYTPlayer.buildControls(YTPlayer),YTPlayer.overlay)if(YTPlayer.opt.addRaster){let e="dot"==YTPlayer.opt.addRaster?"raster-dot":"raster";YTPlayer.overlay.addClass(YTPlayer.isRetina?e+" retina":e)}else YTPlayer.overlay.removeClass((function(e,r){let t=r.split(" "),a=[];return jQuery.each(t,(function(e,r){/raster.*/.test(r)&&a.push(r)})),a.push("retina"),a.join(" ")}));YTPlayer.preventTrigger=!0,YTPlayer.state=2,YTPlayer.preventTrigger=!0,YTPlayer.player.mute(),YTPlayer.player.playVideo(),YTPlayer.isStarting=!0;let startAt=YTPlayer.start_from_last?YTPlayer.start_from_last:YTPlayer.opt.startAt?YTPlayer.opt.startAt:1;return YTPlayer.preventTrigger=!0,YTPlayer.checkForStartAt=setInterval((function(){YTPlayer.player.mute(),YTPlayer.player.seekTo(startAt,!0);let canPlayVideo=YTPlayer.player.getVideoLoadedFraction()>=startAt/YTPlayer.player.getDuration();if(jQuery.browser.mobile&&(canPlayVideo=!0),YTPlayer.player.getDuration()>0&&YTPlayer.player.getCurrentTime()>=startAt&&canPlayVideo){YTPlayer.start_from_last=null,YTPlayer.preventTrigger=!0,$YTPlayer.YTPPause(),clearInterval(YTPlayer.checkForStartAt),"function"==typeof YTPlayer.opt.onReady&&YTPlayer.opt.onReady(YTPlayer),YTPlayer.isReady=!0,$YTPlayer.YTPRemoveFilter(),YTPlayer.opt.addFilters?$YTPlayer.YTPApplyFilters(YTPlayer.opt.addFilters):$YTPlayer.YTPApplyFilters(),$YTPlayer.YTPEnableFilters();let YTPready=jQuery.Event("YTPReady");if(YTPready.time=YTPlayer.currentTime,$YTPlayer.trigger(YTPready),YTPlayer.state=2,YTPlayer.opt.mute?$YTPlayer.YTPMute():YTPlayer.opt.autoPlay?(console.debug("We muted the audio to make the video 'auto-play' according with the latest vendor policy. The audio will unmute at the first user interaction with the page"),YTPlayer.player.mute(),YTPlayer.forcedMuted=!0,jQuery(document).on("mousedown.YTPstartAudio",(function(){YTPlayer.forcedMuted&&(console.debug("AAAAAAA"),YTPlayer.player.unMute(),YTPlayer.forcedMuted=!1,jQuery(document).off("mousedown.YTPstartAudio"))})),jQuery(window).on("scroll",(function(){console.debug("AAAAA")}))):YTPlayer.player.unMute(),"undefined"!=typeof _gaq&&eval(YTPlayer.opt.gaTrack)?_gaq.push(["_trackEvent","YTPlayer","Play",YTPlayer.hasData?YTPlayer.videoData.title:YTPlayer.videoID.toString()]):"undefined"!=typeof ga&&eval(YTPlayer.opt.gaTrack)&&ga("send","event","YTPlayer","play",YTPlayer.hasData?YTPlayer.videoData.title:YTPlayer.videoID.toString()),YTPlayer.opt.autoPlay){let e=jQuery.Event("YTPStart");e.time=YTPlayer.currentTime,jQuery(YTPlayer).trigger(e),YTPlayer.isStarting=!1,"mac"===jQuery.mbBrowser.os.name&&jQuery.mbBrowser.safari&&jQuery("body").one("mousedown.YTPstart",(function(){$YTPlayer.YTPPlay()})),$YTPlayer.YTPPlay(),console.timeEnd(YTPTimerLabels.startPlaying)}else YTPlayer.preventTrigger=!0,$YTPlayer.YTPPause(),YTPlayer.start_from_last&&YTPlayer.player.seekTo(startAt,!0),setTimeout((function(){YTPlayer.preventTrigger=!0,$YTPlayer.YTPPause(),YTPlayer.isPlayer||(YTPlayer.opt.coverImage?(YTPlayer.wrapper.css({opacity:0}),setTimeout((function(){$YTPlayer.changeCoverImage()}),YTPlayer.opt.fadeOnStartTime)):(jQuery(YTPlayer.playerEl).CSSAnimate({opacity:1},YTPlayer.opt.fadeOnStartTime),YTPlayer.wrapper.CSSAnimate({opacity:YTPlayer.isAlone?1:YTPlayer.opt.opacity},YTPlayer.opt.fadeOnStartTime))),YTPlayer.isStarting=!1}),500),YTPlayer.controlBar.length&&YTPlayer.controlBar.find(".mb_YTPPlayPause").html(jQuery.mbYTPlayer.controls.play);YTPlayer.isPlayer&&!YTPlayer.opt.autoPlay&&YTPlayer.loading&&YTPlayer.loading.length&&(YTPlayer.loading.html("Ready"),setTimeout((function(){YTPlayer.loading.fadeOut()}),100)),YTPlayer.controlBar&&YTPlayer.controlBar.length&&YTPlayer.controlBar.slideDown(1e3)}"mac"===jQuery.mbBrowser.os.name&&jQuery.mbBrowser.safari&&(YTPlayer.player.playVideo(),startAt>=0&&YTPlayer.player.seekTo(startAt,!0))}),100),$YTPlayer},getTime:function e(){let r=this.get(0);return jQuery.mbYTPlayer.formatTime(r.currentTime)},getTotalTime:function e(){let r=this.get(0);return jQuery.mbYTPlayer.formatTime(r.totalTime)},formatTime:function e(r){let t=Math.floor(r/60),a=Math.floor(r-60*t);return(t<=9?"0"+t:t)+" : "+(a<=9?"0"+a:a)},setAnchor:function e(r){let t;this.optimizeDisplay(r)},getAnchor:function e(){let r;return this.get(0).opt.anchor},setAbundance:function e(r,t){let a=this.get(0),o=this;return t&&(a.opt.abundance=r),o.optimizeDisplay(a.opt.anchor,r),o},getAbundance:function e(){let r;return this.get(0).opt.abundance},setOption:function e(r,t){let a,o=this;return this.get(0).opt[r]=t,o}},jQuery.fn.optimizeDisplay=function(anchor,abundanceX){let YTPlayer=this.get(0),vid={},el=YTPlayer.wrapper,iframe=jQuery(YTPlayer.playerEl);YTPlayer.opt.anchor=anchor||YTPlayer.opt.anchor,YTPlayer.opt.anchor="undefined "!=typeof YTPlayer.opt.anchor?YTPlayer.opt.anchor:"center,center";let YTPAlign=YTPlayer.opt.anchor.split(","),ab=abundanceX||YTPlayer.opt.abundance;if(YTPlayer.opt.optimizeDisplay){let abundance=el.height()*ab,win={};win.width=el.outerWidth(),win.height=el.outerHeight()+abundance,YTPlayer.opt.ratio="auto"===YTPlayer.opt.ratio?16/9:YTPlayer.opt.ratio,YTPlayer.opt.ratio=eval(YTPlayer.opt.ratio),vid.width=win.width+abundance,vid.height=Math.ceil(vid.width/YTPlayer.opt.ratio),vid.marginTop=Math.ceil(-(vid.height-win.height+abundance)/2),vid.marginLeft=-abundance/2;let lowest=vid.height<win.height;lowest&&(vid.height=win.height+abundance,vid.width=Math.ceil(vid.height*YTPlayer.opt.ratio),vid.marginTop=-abundance/2,vid.marginLeft=Math.ceil(-(vid.width-win.width)/2));for(let e in YTPAlign)if(YTPAlign.hasOwnProperty(e)){let r=YTPAlign[e].replace(/ /g,"");switch(r){case"top":vid.marginTop=-abundance;break;case"bottom":vid.marginTop=Math.ceil(-(vid.height-win.height)-abundance/2);break;case"left":vid.marginLeft=-abundance;break;case"right":vid.marginLeft=Math.ceil(-(vid.width-win.width)+abundance/2);break}}}else vid.width="100%",vid.height="100%",vid.marginTop=0,vid.marginLeft=0;iframe.css({width:vid.width,height:vid.height,marginTop:vid.marginTop,marginLeft:vid.marginLeft,maxWidth:"initial"})},jQuery.shuffle=function(e){let r=e.slice(),t=r.length,a=t;for(;a--;){let e=parseInt(Math.random()*t),o=r[a];r[a]=r[e],r[e]=o}return r},jQuery.fn.unselectable=function(){return this.each((function(){jQuery(this).css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).attr("unselectable","on")}))},jQuery.fn.YTPlayer=jQuery.mbYTPlayer.buildPlayer,jQuery.fn.mb_YTPlayer=jQuery.mbYTPlayer.buildPlayer,jQuery.fn.YTPCheckForState=jQuery.mbYTPlayer.checkForState,jQuery.fn.YTPGetPlayer=jQuery.mbYTPlayer.getPlayer,jQuery.fn.YTPGetVideoID=jQuery.mbYTPlayer.getVideoID,jQuery.fn.YTPGetPlaylistID=jQuery.mbYTPlayer.getPlaylistID,jQuery.fn.YTPChangeVideo=jQuery.fn.YTPChangeMovie=jQuery.mbYTPlayer.changeVideo,jQuery.fn.YTPPlayerDestroy=jQuery.mbYTPlayer.playerDestroy,jQuery.fn.YTPPlay=jQuery.mbYTPlayer.play,jQuery.fn.YTPTogglePlay=jQuery.mbYTPlayer.togglePlay,jQuery.fn.YTPStop=jQuery.mbYTPlayer.stop,jQuery.fn.YTPPause=jQuery.mbYTPlayer.pause,jQuery.fn.YTPSeekTo=jQuery.mbYTPlayer.seekTo,jQuery.fn.YTPGetPlaybackRate=jQuery.mbYTPlayer.getPlaybackRate,jQuery.fn.YTPSetPlaybackRate=jQuery.mbYTPlayer.setPlaybackRate,jQuery.fn.changeCoverImage=jQuery.mbYTPlayer.changeCoverImage,jQuery.fn.YTPlaylist=jQuery.mbYTPlayer.playlist,jQuery.fn.YTPPlayNext=jQuery.mbYTPlayer.playNext,jQuery.fn.YTPPlayPrev=jQuery.mbYTPlayer.playPrev,jQuery.fn.YTPPlayIndex=jQuery.mbYTPlayer.playIndex,jQuery.fn.YTPMute=jQuery.mbYTPlayer.mute,jQuery.fn.YTPUnmute=jQuery.mbYTPlayer.unmute,jQuery.fn.YTPToggleVolume=jQuery.mbYTPlayer.toggleVolume,jQuery.fn.YTPSetVolume=jQuery.mbYTPlayer.setVolume,jQuery.fn.YTPGetVolume=jQuery.mbYTPlayer.getVolume,jQuery.fn.YTPGetVideoData=jQuery.mbYTPlayer.getVideoData,jQuery.fn.YTPFullscreen=jQuery.mbYTPlayer.fullscreen,jQuery.fn.YTPToggleLoops=jQuery.mbYTPlayer.toggleLoops,jQuery.fn.YTPManageProgress=jQuery.mbYTPlayer.manageProgress,jQuery.fn.YTPSetVideoQuality=jQuery.mbYTPlayer.setVideoQuality,jQuery.fn.YTPGetVideoQuality=jQuery.mbYTPlayer.getVideoQuality,jQuery.fn.YTPApplyFilter=jQuery.mbYTPlayer.applyFilter,jQuery.fn.YTPApplyFilters=jQuery.mbYTPlayer.applyFilters,jQuery.fn.YTPToggleFilter=jQuery.mbYTPlayer.toggleFilter,jQuery.fn.YTPToggleFilters=jQuery.mbYTPlayer.toggleFilters,jQuery.fn.YTPRemoveFilter=jQuery.mbYTPlayer.removeFilter,jQuery.fn.YTPDisableFilters=jQuery.mbYTPlayer.disableFilters,jQuery.fn.YTPEnableFilters=jQuery.mbYTPlayer.enableFilters,jQuery.fn.YTPGetFilters=jQuery.mbYTPlayer.getFilters,jQuery.fn.YTPGetTime=jQuery.mbYTPlayer.getTime,jQuery.fn.YTPGetTotalTime=jQuery.mbYTPlayer.getTotalTime,jQuery.fn.YTPAddMask=jQuery.mbYTPlayer.addMask,jQuery.fn.YTPRemoveMask=jQuery.mbYTPlayer.removeMask,jQuery.fn.YTPToggleMask=jQuery.mbYTPlayer.toggleMask,jQuery.fn.YTPGetAbundance=jQuery.mbYTPlayer.getAbundance,jQuery.fn.YTPSetAbundance=jQuery.mbYTPlayer.setAbundance,jQuery.fn.YTPSetAnchor=jQuery.mbYTPlayer.setAnchor,jQuery.fn.YTPGetAnchor=jQuery.mbYTPlayer.getAnchor,jQuery.fn.YTPSetOption=jQuery.mbYTPlayer.setOption})(jQuery,ytp);var nAgt=navigator.userAgent;jQuery.browser=jQuery.browser||{},jQuery.browser.mozilla=!1,jQuery.browser.webkit=!1,jQuery.browser.opera=!1,jQuery.browser.safari=!1,jQuery.browser.chrome=!1,jQuery.browser.androidStock=!1,jQuery.browser.msie=!1,jQuery.browser.edge=!1,jQuery.browser.ua=nAgt;var getOS=function e(){var r={version:"Unknown version",name:"Unknown OS"};return-1!=navigator.appVersion.indexOf("Win")&&(r.name="Windows"),-1!=navigator.appVersion.indexOf("Mac")&&0>navigator.appVersion.indexOf("Mobile")&&(r.name="Mac"),-1!=navigator.appVersion.indexOf("Linux")&&(r.name="Linux"),/Mac OS X/.test(nAgt)&&!/Mobile/.test(nAgt)&&(r.version=/Mac OS X ([\._\d]+)/.exec(nAgt)[1],r.version=r.version.replace(/_/g,".").substring(0,5)),/Windows/.test(nAgt)&&(r.version="Unknown.Unknown"),/Windows NT 5.1/.test(nAgt)&&(r.version="5.1"),/Windows NT 6.0/.test(nAgt)&&(r.version="6.0"),/Windows NT 6.1/.test(nAgt)&&(r.version="6.1"),/Windows NT 6.2/.test(nAgt)&&(r.version="6.2"),/Windows NT 10.0/.test(nAgt)&&(r.version="10.0"),/Linux/.test(nAgt)&&/Linux/.test(nAgt)&&(r.version="Unknown.Unknown"),r.name=r.name.toLowerCase(),r.major_version="Unknown",r.minor_version="Unknown","Unknown.Unknown"!=r.version&&(r.major_version=parseFloat(r.version.split(".")[0]),r.minor_version=parseFloat(r.version.split(".")[1])),r},nameOffset,verOffset,ix;if(jQuery.browser.os=getOS(),jQuery.browser.hasTouch=isTouchSupported(),jQuery.browser.name=navigator.appName,jQuery.browser.fullVersion=""+parseFloat(navigator.appVersion),jQuery.browser.majorVersion=parseInt(navigator.appVersion,10),-1!=(verOffset=nAgt.indexOf("Opera")))jQuery.browser.opera=!0,jQuery.browser.name="Opera",jQuery.browser.fullVersion=nAgt.substring(verOffset+6),-1!=(verOffset=nAgt.indexOf("Version"))&&(jQuery.browser.fullVersion=nAgt.substring(verOffset+8));else if(-1!=(verOffset=nAgt.indexOf("OPR")))jQuery.browser.opera=!0,jQuery.browser.name="Opera",jQuery.browser.fullVersion=nAgt.substring(verOffset+4);else if(-1!=(verOffset=nAgt.indexOf("MSIE")))jQuery.browser.msie=!0,jQuery.browser.name="Microsoft Internet Explorer",jQuery.browser.fullVersion=nAgt.substring(verOffset+5);else if(-1!=nAgt.indexOf("Trident")){jQuery.browser.msie=!0,jQuery.browser.name="Microsoft Internet Explorer";var start=nAgt.indexOf("rv:")+3,end=start+4;jQuery.browser.fullVersion=nAgt.substring(start,end)}else-1!=(verOffset=nAgt.indexOf("Edge"))?(jQuery.browser.edge=!0,jQuery.browser.name="Microsoft Edge",jQuery.browser.fullVersion=nAgt.substring(verOffset+5)):-1!=(verOffset=nAgt.indexOf("Chrome"))?(jQuery.browser.webkit=!0,jQuery.browser.chrome=!0,jQuery.browser.name="Chrome",jQuery.browser.fullVersion=nAgt.substring(verOffset+7)):-1<nAgt.indexOf("mozilla/5.0")&&-1<nAgt.indexOf("android ")&&-1<nAgt.indexOf("applewebkit")&&!(-1<nAgt.indexOf("chrome"))?(verOffset=nAgt.indexOf("Chrome"),jQuery.browser.webkit=!0,jQuery.browser.androidStock=!0,jQuery.browser.name="androidStock",jQuery.browser.fullVersion=nAgt.substring(verOffset+7)):-1!=(verOffset=nAgt.indexOf("Safari"))||-1!=(verOffset=nAgt.indexOf("AppleWebkit"))?(jQuery.browser.webkit=!0,jQuery.browser.safari=!0,jQuery.browser.name="Safari",jQuery.browser.fullVersion=nAgt.substring(verOffset+7),-1!=(verOffset=nAgt.indexOf("Version"))&&(jQuery.browser.fullVersion=nAgt.substring(verOffset+8))):-1!=(verOffset=nAgt.indexOf("Firefox"))?(jQuery.browser.mozilla=!0,jQuery.browser.name="Firefox",jQuery.browser.fullVersion=nAgt.substring(verOffset+8)):(nameOffset=nAgt.lastIndexOf(" ")+1)<(verOffset=nAgt.lastIndexOf("/"))&&(jQuery.browser.name=nAgt.substring(nameOffset,verOffset),jQuery.browser.fullVersion=nAgt.substring(verOffset+1),jQuery.browser.name.toLowerCase()==jQuery.browser.name.toUpperCase()&&(jQuery.browser.name=navigator.appName));-1!=(ix=jQuery.browser.fullVersion.indexOf(";"))&&(jQuery.browser.fullVersion=jQuery.browser.fullVersion.substring(0,ix)),-1!=(ix=jQuery.browser.fullVersion.indexOf(" "))&&(jQuery.browser.fullVersion=jQuery.browser.fullVersion.substring(0,ix)),jQuery.browser.majorVersion=parseInt(""+jQuery.browser.fullVersion,10),isNaN(jQuery.browser.majorVersion)&&(jQuery.browser.fullVersion=""+parseFloat(navigator.appVersion),jQuery.browser.majorVersion=parseInt(navigator.appVersion,10)),jQuery.browser.version=jQuery.browser.majorVersion,jQuery.browser.android=/Android/i.test(nAgt),jQuery.browser.blackberry=/BlackBerry|BB|PlayBook/i.test(nAgt),jQuery.browser.ios=/iPhone|iPad|iPod|webOS/i.test(nAgt),jQuery.browser.operaMobile=/Opera Mini/i.test(nAgt),jQuery.browser.windowsMobile=/IEMobile|Windows Phone/i.test(nAgt),jQuery.browser.kindle=/Kindle|Silk/i.test(nAgt),jQuery.browser.mobile=jQuery.browser.android||jQuery.browser.blackberry||jQuery.browser.ios||jQuery.browser.windowsMobile||jQuery.browser.operaMobile||jQuery.browser.kindle,jQuery.isMobile=jQuery.browser.mobile,jQuery.isTablet=jQuery.browser.mobile&&765<jQuery(window).width(),jQuery.isAndroidDefault=jQuery.browser.android&&!/chrome/i.test(nAgt),jQuery.mbBrowser=jQuery.browser,jQuery.browser.versionCompare=function(e,r){if("stringstring"!=typeof e+typeof r)return!1;for(var t=e.split("."),a=r.split("."),o=0,l=Math.max(t.length,a.length);o<l;o++){if(t[o]&&!a[o]&&0<parseInt(t[o])||parseInt(t[o])>parseInt(a[o]))return 1;if(a[o]&&!t[o]&&0<parseInt(a[o])||parseInt(t[o])<parseInt(a[o]))return-1}return 0},jQuery.support.CSStransition=function(){var e=(document.body||document.documentElement).style;return void 0!==e.transition||void 0!==e.WebkitTransition||void 0!==e.MozTransition||void 0!==e.MsTransition||void 0!==e.OTransition}(),jQuery.CSS={name:"mb.CSSAnimate",author:"Matteo Bicocchi",version:"2.0.0",transitionEnd:"transitionEnd",sfx:"",filters:{blur:{min:0,max:100,unit:"px"},brightness:{min:0,max:400,unit:"%"},contrast:{min:0,max:400,unit:"%"},grayscale:{min:0,max:100,unit:"%"},hueRotate:{min:0,max:360,unit:"deg"},invert:{min:0,max:100,unit:"%"},saturate:{min:0,max:400,unit:"%"},sepia:{min:0,max:100,unit:"%"}},normalizeCss:function e(r){var t=jQuery.extend(!0,{},r);for(var a in jQuery.browser.webkit||jQuery.browser.opera?jQuery.CSS.sfx="-webkit-":jQuery.browser.mozilla?jQuery.CSS.sfx="-moz-":jQuery.browser.msie&&(jQuery.CSS.sfx="-ms-"),jQuery.CSS.sfx="",t){if("transform"===a&&(t[jQuery.CSS.sfx+"transform"]=t[a],delete t[a]),"transform-origin"===a&&(t[jQuery.CSS.sfx+"transform-origin"]=r[a],delete t[a]),"filter"!==a||jQuery.browser.mozilla||(t[jQuery.CSS.sfx+"filter"]=r[a],delete t[a]),"blur"===a&&setFilter(t,"blur",r[a]),"brightness"===a&&setFilter(t,"brightness",r[a]),"contrast"===a&&setFilter(t,"contrast",r[a]),"grayscale"===a&&setFilter(t,"grayscale",r[a]),"hueRotate"===a&&setFilter(t,"hueRotate",r[a]),"invert"===a&&setFilter(t,"invert",r[a]),"saturate"===a&&setFilter(t,"saturate",r[a]),"sepia"===a&&setFilter(t,"sepia",r[a]),"x"===a){var o=jQuery.CSS.sfx+"transform";t[o]=t[o]||"",t[o]+=" translateX("+setUnit(r[a],"px")+")",delete t[a]}"y"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" translateY("+setUnit(r[a],"px")+")",delete t[a]),"z"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" translateZ("+setUnit(r[a],"px")+")",delete t[a]),"rotate"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" rotate("+setUnit(r[a],"deg")+")",delete t[a]),"rotateX"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" rotateX("+setUnit(r[a],"deg")+")",delete t[a]),"rotateY"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" rotateY("+setUnit(r[a],"deg")+")",delete t[a]),"rotateZ"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" rotateZ("+setUnit(r[a],"deg")+")",delete t[a]),"scale"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" scale("+setUnit(r[a],"")+")",delete t[a]),"scaleX"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" scaleX("+setUnit(r[a],"")+")",delete t[a]),"scaleY"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" scaleY("+setUnit(r[a],"")+")",delete t[a]),"scaleZ"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" scaleZ("+setUnit(r[a],"")+")",delete t[a]),"skew"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" skew("+setUnit(r[a],"deg")+")",delete t[a]),"skewX"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" skewX("+setUnit(r[a],"deg")+")",delete t[a]),"skewY"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" skewY("+setUnit(r[a],"deg")+")",delete t[a]),"perspective"===a&&(t[o=jQuery.CSS.sfx+"transform"]=t[o]||"",t[o]+=" perspective("+setUnit(r[a],"px")+")",delete t[a])}return t},getProp:function e(r){var t=[],a;for(a in r)0>t.indexOf(a)&&t.push(uncamel(a));return t.join(",")},animate:function e(r,t,a,o,l){return this.each((function(){function e(){n.called=!0,n.CSSAIsRunning=!1,i.off(jQuery.CSS.transitionEnd+"."+n.id),clearTimeout(n.timeout),i.css(jQuery.CSS.sfx+"transition",""),"function"==typeof l&&l.apply(n),"function"==typeof n.CSSqueue&&(n.CSSqueue(),n.CSSqueue=null)}var n=this,i=jQuery(this);n.id=n.id||"CSSA_"+(new Date).getTime();var s=s||{type:"noEvent"};if(n.CSSAIsRunning&&n.eventType==s.type&&!jQuery.browser.msie&&9>=jQuery.browser.version)n.CSSqueue=function(){i.CSSAnimate(r,t,a,o,l)};else if(n.CSSqueue=null,n.eventType=s.type,0!==i.length&&r){if(r=jQuery.normalizeCss(r),n.CSSAIsRunning=!0,"function"==typeof t&&(l=t,t=jQuery.fx.speeds._default),"function"==typeof a&&(o=a,a=0),"string"==typeof a&&(l=a,a=0),"function"==typeof o&&(l=o,o="cubic-bezier(0.65,0.03,0.36,0.72)"),"string"==typeof t)for(var u in jQuery.fx.speeds){if(t==u){t=jQuery.fx.speeds[u];break}t=jQuery.fx.speeds._default}if(t||(t=jQuery.fx.speeds._default),"string"==typeof l&&(o=l,l=null),jQuery.support.CSStransition){var y={default:"ease",in:"ease-in",out:"ease-out","in-out":"ease-in-out",snap:"cubic-bezier(0,1,.5,1)",easeOutCubic:"cubic-bezier(.215,.61,.355,1)",easeInOutCubic:"cubic-bezier(.645,.045,.355,1)",easeInCirc:"cubic-bezier(.6,.04,.98,.335)",easeOutCirc:"cubic-bezier(.075,.82,.165,1)",easeInOutCirc:"cubic-bezier(.785,.135,.15,.86)",easeInExpo:"cubic-bezier(.95,.05,.795,.035)",easeOutExpo:"cubic-bezier(.19,1,.22,1)",easeInOutExpo:"cubic-bezier(1,0,0,1)",easeInQuad:"cubic-bezier(.55,.085,.68,.53)",easeOutQuad:"cubic-bezier(.25,.46,.45,.94)",easeInOutQuad:"cubic-bezier(.455,.03,.515,.955)",easeInQuart:"cubic-bezier(.895,.03,.685,.22)",easeOutQuart:"cubic-bezier(.165,.84,.44,1)",easeInOutQuart:"cubic-bezier(.77,0,.175,1)",easeInQuint:"cubic-bezier(.755,.05,.855,.06)",easeOutQuint:"cubic-bezier(.23,1,.32,1)",easeInOutQuint:"cubic-bezier(.86,0,.07,1)",easeInSine:"cubic-bezier(.47,0,.745,.715)",easeOutSine:"cubic-bezier(.39,.575,.565,1)",easeInOutSine:"cubic-bezier(.445,.05,.55,.95)",easeInBack:"cubic-bezier(.6,-.28,.735,.045)",easeOutBack:"cubic-bezier(.175, .885,.32,1.275)",easeInOutBack:"cubic-bezier(.68,-.55,.265,1.55)"};y[o]&&(o=y[o]),i.off(jQuery.CSS.transitionEnd+"."+n.id),y=jQuery.CSS.getProp(r);var d={};jQuery.extend(d,r),d[jQuery.CSS.sfx+"transition-property"]=y,d[jQuery.CSS.sfx+"transition-duration"]=t+"ms",d[jQuery.CSS.sfx+"transition-delay"]=a+"ms",d[jQuery.CSS.sfx+"transition-timing-function"]=o,setTimeout((function(){i.one(jQuery.CSS.transitionEnd+"."+n.id,e),i.css(d)}),1),n.timeout=setTimeout((function(){n.called||!l?(n.called=!1,n.CSSAIsRunning=!1):(i.css(jQuery.CSS.sfx+"transition",""),l.apply(n),n.CSSAIsRunning=!1,"function"==typeof n.CSSqueue&&(n.CSSqueue(),n.CSSqueue=null))}),t+a+10)}else{for(y in r)"transform"===y&&delete r[y],"filter"===y&&delete r[y],"transform-origin"===y&&delete r[y],"auto"===r[y]&&delete r[y],"x"===y&&(s=r[y],r[u="left"]=s,delete r[y]),"y"===y&&(s=r[y],r[u="top"]=s,delete r[y]),"-ms-transform"!==y&&"-ms-filter"!==y||delete r[y];i.delay(a).animate(r,t,l)}}}))}},jQuery.fn.CSSAnimate=jQuery.CSS.animate,jQuery.normalizeCss=jQuery.CSS.normalizeCss,jQuery.fn.css3=function(e){return this.each((function(){var r=jQuery(this),t=jQuery.normalizeCss(e);r.css(t)}))},function(e){e.simpleSlider={defaults:{initialval:0,maxval:100,orientation:"h",readonly:!1,callback:!1},events:{start:e.browser.mobile?"touchstart":"mousedown",end:e.browser.mobile?"touchend":"mouseup",move:e.browser.mobile?"touchmove":"mousemove"},init:function r(t){return this.each((function(){var r=this,a=e(r);a.addClass("simpleSlider"),r.opt={},e.extend(r.opt,e.simpleSlider.defaults,t),e.extend(r.opt,a.data()),console.debug(a.data());var o="h"==r.opt.orientation?"horizontal":"vertical",l=e("<div/>").addClass("level").addClass(o);a.prepend(l),r.level=l,a.css({cursor:"default"}),"auto"==r.opt.maxval&&(r.opt.maxval=e(r).outerWidth()),a.updateSliderVal(),r.opt.readonly||(a.on(e.simpleSlider.events.start,(function(t){e.browser.mobile&&(t=t.changedTouches[0]),r.canSlide=!0,a.updateSliderVal(t),"h"==r.opt.orientation?a.css({cursor:"col-resize"}):a.css({cursor:"row-resize"}),r.lastVal=r.val,e.browser.mobile||(t.preventDefault(),t.stopPropagation())})),e(document).on(e.simpleSlider.events.move,(function(t){e.browser.mobile&&(t=t.changedTouches[0]),r.canSlide&&(e(document).css({cursor:"default"}),a.updateSliderVal(t),e.browser.mobile||(t.preventDefault(),t.stopPropagation()))})).on(e.simpleSlider.events.end,(function(){e(document).css({cursor:"auto"}),r.canSlide=!1,a.css({cursor:"auto"})})))}))},updateSliderVal:function r(t){function a(e,r){return Math.floor(100*e/r)}var o=this,l=o.get(0);if(l.opt){l.opt.initialval="number"==typeof l.opt.initialval?l.opt.initialval:l.opt.initialval(l);var n=e(l).outerWidth(),i=e(l).outerHeight();l.x="object"==typeof t?t.clientX+document.body.scrollLeft-o.offset().left:"number"==typeof t?t*n/l.opt.maxval:l.opt.initialval*n/l.opt.maxval,l.y="object"==typeof t?t.clientY+document.body.scrollTop-o.offset().top:"number"==typeof t?(l.opt.maxval-l.opt.initialval-t)*i/l.opt.maxval:l.opt.initialval*i/l.opt.maxval,l.y=o.outerHeight()-l.y,l.scaleX=l.x*l.opt.maxval/n,l.scaleY=l.y*l.opt.maxval/i,l.outOfRangeX=l.scaleX>l.opt.maxval?l.scaleX-l.opt.maxval:l.scaleX<0?l.scaleX:0,l.outOfRangeY=l.scaleY>l.opt.maxval?l.scaleY-l.opt.maxval:l.scaleY<0?l.scaleY:0,l.outOfRange="h"==l.opt.orientation?l.outOfRangeX:l.outOfRangeY,l.value=void 0!==t?"h"==l.opt.orientation?l.x>=o.outerWidth()?l.opt.maxval:l.x<=0?0:l.scaleX:l.y>=o.outerHeight()?l.opt.maxval:l.y<=0?0:l.scaleY:"h"==l.opt.orientation?l.scaleX:l.scaleY,"h"==l.opt.orientation?l.level.width(a(l.x,n)+"%"):l.level.height(a(l.y,i)),l.lastVal===l.value&&("h"===l.opt.orientation&&(l.x>=o.outerWidth()||l.x<=0)||"h"!==l.opt.orientation&&(l.y>=o.outerHeight()||l.y<=0))||("function"==typeof l.opt.callback&&l.opt.callback(l),l.lastVal=l.value)}}},e.fn.simpleSlider=e.simpleSlider.init,e.fn.updateSliderVal=e.simpleSlider.updateSliderVal}(jQuery),function(e){e.mbCookie={set:function e(r,t,a,o){"object"==typeof t&&(t=JSON.stringify(t)),o=o?"; domain="+o:"";var l=new Date,n="";0<a&&(l.setTime(l.getTime()+864e5*a),n="; expires="+l.toGMTString()),document.cookie=r+"="+t+n+"; path=/"+o},get:function e(r){r+="=";for(var t=document.cookie.split(";"),a=0;a<t.length;a++){for(var o=t[a];" "==o.charAt(0);)o=o.substring(1,o.length);if(0==o.indexOf(r))try{return JSON.parse(o.substring(r.length,o.length))}catch(e){return o.substring(r.length,o.length)}}return null},remove:function r(t){e.mbCookie.set(t,"",-1)}},e.mbStorage={set:function e(r,t){"object"==typeof t&&(t=JSON.stringify(t)),localStorage.setItem(r,t)},get:function e(r){if(!localStorage[r])return null;try{return JSON.parse(localStorage[r])}catch(e){return localStorage[r]}},remove:function e(r){r?localStorage.removeItem(r):localStorage.clear()}}}(jQuery);